/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Sig.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    rcX signal / event function prototypes and definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2011-05-20  ported from rcX V2

**************************************************************************************/

#ifndef __AP_SIG_H
#define __AP_SIG_H

#ifdef __cplusplus
  extern "C" {
#endif

  /*************************************************************
  *   Function Prototypes
  *************************************************************/
  RX_RESULT FAR   rX_SigCreateSignal    (const STRING FAR*    pszIdn,
                                         UINT FAR*            puSignl,
                                         BOOLEAN              fManRst);

  RX_RESULT FAR   rX_SigIdentifySignal  (const STRING FAR*    pszIdn,
                                         UINT                 uInst,
                                         UINT FAR*            puSignlIdx);

  RX_RESULT FAR   rX_SigDeleteSignal    (UINT                 uSignlIdx);

  RX_RESULT FAR   rX_SigWaitForSignal   (UINT                 uSignlIdx,
                                         UINT                 uTimOpt);

  RX_RESULT FAR   rX_SigSetSignal       (UINT                 uSignlIdx);

  RX_RESULT FAR   rX_SigResetSignal     (UINT                 uSignlIdx);


#ifdef __cplusplus
  }
#endif

#endif /* __AP_SIG_H */
